<?php
// admin/dashboard.php - Admin dashboard
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/functions.php';
session_start();
if (!is_admin_logged_in()) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Nexshop</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container" style="max-width:900px;margin:2rem auto;">
    <h2>Admin Dashboard</h2>
    <nav style="margin-bottom:2rem;">
        <a href="dashboard.php" class="btn">Dashboard</a>
        <a href="products.php" class="btn">Products</a>
        <a href="orders.php" class="btn">Orders</a>
        <a href="logout.php" class="btn" style="background:#e74c3c;">Logout</a>
    </nav>
    <div>
        <h3>Quick Stats</h3>
        <ul style="list-style:none;padding:0;">
            <li>Total Products: <?php echo $pdo->query('SELECT COUNT(*) FROM products')->fetchColumn(); ?></li>
            <li>Total Orders: <?php echo $pdo->query('SELECT COUNT(*) FROM orders')->fetchColumn(); ?></li>
        </ul>
    </div>
</div>
</body>
</html>
