<?php
// admin/index.php - Admin login page
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/functions.php';
session_start();
if (is_admin_logged_in()) {
    header('Location: dashboard.php');
    exit;
}
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $stmt = $pdo->prepare('SELECT * FROM admin_users WHERE username = ?');
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $username;
        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'Invalid credentials.';
    }
}
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Nexshop</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body style="background:#f8f5f2;">
<div class="container" style="max-width:400px;margin:4rem auto;">
    <h2 style="text-align:center;">Admin Login</h2>
    <?php if ($error): ?><div style="color:#e74c3c;"> <?php echo $error; ?> </div><?php endif; ?>
    <form method="post" style="margin-top:2rem;">
        <label>Username</label>
        <input type="text" name="username" required>
        <label>Password</label>
        <input type="password" name="password" required>
        <button type="submit" class="btn" style="width:100%;">Login</button>
    </form>
</div>
</body>
</html>