<?php
// admin/order-detail.php - Order detail and status update
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/functions.php';
session_start();
if (!is_admin_logged_in()) {
    header('Location: index.php');
    exit;
}
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $pdo->prepare('SELECT * FROM orders WHERE id = ?');
$stmt->execute([$id]);
$order = $stmt->fetch();
if (!$order) { die('Order not found.'); }
$items = $pdo->prepare('SELECT oi.*, p.name, p.image FROM order_items oi JOIN products p ON oi.product_id = p.id WHERE oi.order_id = ?');
$items->execute([$id]);
$items = $items->fetchAll();

// Handle status update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['status'])) {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        die('Invalid CSRF token');
    }
    $status = in_array($_POST['status'], ['pending','shipped','completed']) ? $_POST['status'] : 'pending';
    $stmt = $pdo->prepare('UPDATE orders SET status=? WHERE id=?');
    $stmt->execute([$status, $id]);
    header('Location: order-detail.php?id='.$id);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order #<?php echo $order['id']; ?> - Nexshop</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container" style="max-width:700px;margin:2rem auto;">
    <h2>Order #<?php echo $order['id']; ?></h2>
    <p><strong>Customer:</strong> <?php echo sanitize($order['customer_name']); ?><br>
    <strong>Phone:</strong> <?php echo sanitize($order['customer_phone']); ?><br>
    <strong>Address:</strong> <?php echo nl2br(sanitize($order['customer_address'])); ?><br>
    <strong>Total:</strong> ₺<?php echo number_format($order['total'],2); ?><br>
    <strong>Status:</strong> <?php echo ucfirst($order['status']); ?></p>
    <form method="post" style="margin-bottom:2rem;">
        <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
        <select name="status">
            <option value="pending" <?php if($order['status']=='pending') echo 'selected'; ?>>Pending</option>
            <option value="shipped" <?php if($order['status']=='shipped') echo 'selected'; ?>>Shipped</option>
            <option value="completed" <?php if($order['status']=='completed') echo 'selected'; ?>>Completed</option>
        </select>
        <button type="submit" class="btn">Update Status</button>
    </form>
    <h3>Items</h3>
    <table class="cart-table">
        <tr><th>Product</th><th>Price</th><th>Qty</th><th>Subtotal</th></tr>
        <?php foreach ($items as $item): ?>
        <tr>
            <td><img src="../assets/images/<?php echo sanitize($item['image']); ?>" style="width:40px;vertical-align:middle;"> <?php echo sanitize($item['name']); ?></td>
            <td>₺<?php echo number_format($item['price'],2); ?></td>
            <td><?php echo $item['quantity']; ?></td>
            <td>₺<?php echo number_format($item['price']*$item['quantity'],2); ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
    <a href="orders.php" class="btn" style="margin-top:2rem;">Back to Orders</a>
</div>
</body>
</html>
