<?php
// admin/orders.php - Orders listing
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/functions.php';
session_start();
if (!is_admin_logged_in()) {
    header('Location: index.php');
    exit;
}
$orders = $pdo->query('SELECT * FROM orders ORDER BY created_at DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orders - Nexshop</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container" style="max-width:900px;margin:2rem auto;">
    <h2>Orders</h2>
    <table class="cart-table">
        <tr><th>ID</th><th>Customer</th><th>Phone</th><th>Total</th><th>Status</th><th>Created</th><th>Actions</th></tr>
        <?php foreach ($orders as $o): ?>
        <tr>
            <td><?php echo $o['id']; ?></td>
            <td><?php echo sanitize($o['customer_name']); ?></td>
            <td><?php echo sanitize($o['customer_phone']); ?></td>
            <td>₺<?php echo number_format($o['total'],2); ?></td>
            <td><?php echo ucfirst($o['status']); ?></td>
            <td><?php echo $o['created_at']; ?></td>
            <td><a href="order-detail.php?id=<?php echo $o['id']; ?>" class="btn">View</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
