<?php
// admin/product-edit.php - Add/Edit product
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/functions.php';
session_start();
if (!is_admin_logged_in()) {
    header('Location: index.php');
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$product = ['name'=>'','price'=>'','image'=>''];
if ($id) {
    $stmt = $pdo->prepare('SELECT * FROM products WHERE id = ?');
    $stmt->execute([$id]);
    $product = $stmt->fetch();
    if (!$product) { die('Product not found.'); }
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid CSRF token.';
    }
    $name = sanitize($_POST['name'] ?? '');
    $price = (float)($_POST['price'] ?? 0);
    $image = sanitize($_POST['image'] ?? '');
    if (!$name || !$price || !$image) {
        $errors[] = 'All fields required.';
    }
    if (!$errors) {
        if ($id) {
            $stmt = $pdo->prepare('UPDATE products SET name=?, price=?, image=? WHERE id=?');
            $stmt->execute([$name, $price, $image, $id]);
        } else {
            $stmt = $pdo->prepare('INSERT INTO products (name, price, image) VALUES (?, ?, ?)');
            $stmt->execute([$name, $price, $image]);
        }
        header('Location: products.php');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $id ? 'Edit' : 'Add'; ?> Product - Nexshop</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container" style="max-width:500px;margin:2rem auto;">
    <h2><?php echo $id ? 'Edit' : 'Add'; ?> Product</h2>
    <?php if ($errors): ?><div style="color:#e74c3c;"> <?php foreach ($errors as $e) echo '<p>'.$e.'</p>'; ?> </div><?php endif; ?>
    <form method="post">
        <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
        <label>Name</label>
        <input type="text" name="name" value="<?php echo sanitize($product['name']); ?>" required>
        <label>Price</label>
        <input type="number" name="price" value="<?php echo sanitize($product['price']); ?>" step="0.01" required>
        <label>Image Filename (in /assets/images/)</label>
        <input type="text" name="image" value="<?php echo sanitize($product['image']); ?>" required>
        <button type="submit" class="btn" style="width:100%;">Save</button>
    </form>
</div>
</body>
</html>
