<?php
// admin/products.php - Product management
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/functions.php';
session_start();
if (!is_admin_logged_in()) {
    header('Location: index.php');
    exit;
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare('DELETE FROM products WHERE id = ?');
    $stmt->execute([$id]);
    header('Location: products.php');
    exit;
}
$products = $pdo->query('SELECT * FROM products ORDER BY created_at DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Products - Nexshop</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container" style="max-width:900px;margin:2rem auto;">
    <h2>Products</h2>
    <a href="product-edit.php" class="btn" style="margin-bottom:1rem;">Add Product</a>
    <table class="cart-table">
        <tr><th>ID</th><th>Name</th><th>Price</th><th>Image</th><th>Created</th><th>Actions</th></tr>
        <?php foreach ($products as $p): ?>
        <tr>
            <td><?php echo $p['id']; ?></td>
            <td><?php echo sanitize($p['name']); ?></td>
            <td>₺<?php echo number_format($p['price'],2); ?></td>
            <td><img src="../assets/images/<?php echo sanitize($p['image']); ?>" style="width:60px;"></td>
            <td><?php echo $p['created_at']; ?></td>
            <td>
                <a href="product-edit.php?id=<?php echo $p['id']; ?>" class="btn">Edit</a>
                <a href="products.php?delete=<?php echo $p['id']; ?>" class="btn" style="background:#e74c3c;" onclick="return confirm('Delete this product?');">Delete</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
