<?php
// cart.php - Cart page and cart logic
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/functions.php';
include __DIR__.'/includes/header.php';

if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];

// Handle add, update, remove
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        die('Invalid CSRF token');
    }
    $product_id = (int)($_POST['product_id'] ?? 0);
    if (isset($_POST['add'])) {
        // Add to cart
        if (!isset($_SESSION['cart'][$product_id])) {
            $_SESSION['cart'][$product_id] = 1;
        } else {
            $_SESSION['cart'][$product_id]++;
        }
    } elseif (isset($_POST['update'])) {
        $qty = max(1, (int)$_POST['quantity']);
        $_SESSION['cart'][$product_id] = $qty;
    } elseif (isset($_POST['remove'])) {
        unset($_SESSION['cart'][$product_id]);
    } elseif (isset($_POST['product_id'])) {
        // Add from product or home
        if (!isset($_SESSION['cart'][$product_id])) {
            $_SESSION['cart'][$product_id] = 1;
        } else {
            $_SESSION['cart'][$product_id]++;
        }
    }
    header('Location: cart.php');
    exit;
}

$cart = $_SESSION['cart'];
$products = [];
$total = 0;
if ($cart) {
    $ids = implode(',', array_map('intval', array_keys($cart)));
    $stmt = $pdo->query("SELECT * FROM products WHERE id IN ($ids)");
    while ($row = $stmt->fetch()) {
        $row['quantity'] = $cart[$row['id']];
        $row['subtotal'] = $row['quantity'] * $row['price'];
        $products[] = $row;
        $total += $row['subtotal'];
    }
}
?>
<div class="container">
    <h1>Sepetiniz</h1>
    <?php if (!$products): ?>
        <p>Sepetiniz boş.</p>
    <?php else: ?>
    <form method="post">
        <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
        <table class="cart-table">
            <tr><th>Ürün</th><th>Fiyat</th><th>Adet</th><th>Ara Toplam</th><th></th></tr>
            <?php foreach ($products as $item): ?>
            <tr>
                <td><img src="assets/images/<?php echo sanitize($item['image']); ?>" alt="" style="width:50px;vertical-align:middle;"> <?php echo sanitize($item['name']); ?></td>
                <td>₺<?php echo number_format($item['price'],2); ?></td>
                <td>
                    <form method="post" style="display:inline;">
                        <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
                        <input type="hidden" name="product_id" value="<?php echo $item['id']; ?>">
                        <input type="number" name="quantity" value="<?php echo $item['quantity']; ?>" min="1" style="width:50px;">
                        <button type="submit" name="update" class="btn" style="padding:0.3rem 0.7rem;">Güncelle</button>
                    </form>
                </td>
                <td>₺<?php echo number_format($item['subtotal'],2); ?></td>
                <td>
                    <form method="post" style="display:inline;">
                        <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
                        <input type="hidden" name="product_id" value="<?php echo $item['id']; ?>">
                        <button type="submit" name="remove" class="btn" style="background:#e74c3c;">Kaldır</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </form>
    <div style="text-align:right;font-size:1.2rem;font-weight:700;">Toplam: ₺<?php echo number_format($total,2); ?></div>
    <div style="text-align:right;margin-top:1.5rem;">
        <a href="checkout.php" class="btn">Satın Al</a>
    </div>
    <?php endif; ?>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
