<?php
// checkout.php - Checkout page
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/functions.php';
include __DIR__.'/includes/header.php';

if (!isset($_SESSION['cart']) || !$_SESSION['cart']) {
    echo '<div class="container"><p>Your cart is empty.</p></div>';
    include __DIR__.'/includes/footer.php';
    exit;
}

$cart = $_SESSION['cart'];
$products = [];
$total = 0;
$ids = implode(',', array_map('intval', array_keys($cart)));
$stmt = $pdo->query("SELECT * FROM products WHERE id IN ($ids)");
while ($row = $stmt->fetch()) {
    $row['quantity'] = $cart[$row['id']];
    $row['subtotal'] = $row['quantity'] * $row['price'];
    $products[] = $row;
    $total += $row['subtotal'];
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid CSRF token.';
    }
    $name = sanitize($_POST['name'] ?? '');
    $phone = sanitize($_POST['phone'] ?? '');
    $address = sanitize($_POST['address'] ?? '');
    if (!$name || !$phone || !$address) {
        $errors[] = 'All fields are required.';
    }
    if (!$errors) {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare('INSERT INTO orders (customer_name, customer_phone, customer_address, total) VALUES (?, ?, ?, ?)');
        $stmt->execute([$name, $phone, $address, $total]);
        $order_id = $pdo->lastInsertId();
        $stmt = $pdo->prepare('INSERT INTO order_items (order_id, product_id, quantity, price) VALUES (?, ?, ?, ?)');
        foreach ($products as $item) {
            $stmt->execute([$order_id, $item['id'], $item['quantity'], $item['price']]);
        }
        $pdo->commit();
        $_SESSION['cart'] = [];
        header('Location: order-success.php?order_id=' . $order_id);
        exit;
    }
}
?>
<div class="container">
    <h1>Satın Al</h1>
    <?php if ($errors): ?>
        <div style="color:#e74c3c;"> <?php foreach ($errors as $e) echo '<p>'.$e.'</p>'; ?> </div>
    <?php endif; ?>
    <form method="post">
        <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
        <label>Ad Soyad</label>
        <input type="text" name="name" required>
        <label>Telefon</label>
        <input type="text" name="phone" required>
        <label>Adres</label>
        <textarea name="address" required></textarea>
        <div style="margin:1.5rem 0;">
            <strong>Toplam: ₺<?php echo number_format($total,2); ?></strong>
        </div>
        <button type="submit" class="btn">Siparişi Tamamla</button>
    </form>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
