<?php
// index.php - Nex Web Demo Store Home
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/functions.php';
include __DIR__.'/includes/header.php';

$stmt = $pdo->query('SELECT * FROM products ORDER BY created_at DESC LIMIT 12');
$products = $stmt->fetchAll();
?>
<div class="container">
    <h1 style="text-align:center;margin-bottom:2rem;">Yeni Gelenler</h1>
    <div class="products">
        <?php foreach ($products as $product): ?>
        <div class="product-card">
            <a href="product.php?id=<?php echo $product['id']; ?>">
                <img src="assets/images/<?php echo sanitize($product['image']); ?>" alt="<?php echo sanitize($product['name']); ?>">
            </a>
            <h3><?php echo sanitize($product['name']); ?></h3>
            <div class="price">₺<?php echo number_format($product['price'],2); ?></div>
            <form method="post" action="cart.php">
                <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
                <button type="submit" class="btn add-to-cart">Sepete Ekle</button>
            </form>
        </div>
        <?php endforeach; ?>
    </div>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
