<?php
// order-success.php - Order success page
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/functions.php';
include __DIR__.'/includes/header.php';

$order_id = isset($_GET['order_id']) ? (int)$_GET['order_id'] : 0;
$stmt = $pdo->prepare('SELECT * FROM orders WHERE id = ?');
$stmt->execute([$order_id]);
$order = $stmt->fetch();
if (!$order) {
    echo '<div class="container"><p>Sipariş bulunamadı.</p></div>';
    include __DIR__.'/includes/footer.php';
    exit;
}
?>
<div class="container" style="text-align:center;">
    <h1>Siparişiniz için teşekkürler!</h1>
    <p>Siparişiniz başarıyla alınmıştır.<br>Sipariş No: <strong>#<?php echo $order['id']; ?></strong></p>
    <p>Durum: <strong><?php echo ucfirst($order['status']); ?></strong></p>
    <a href="index.php" class="btn" style="margin-top:2rem;">Alışverişe Devam Et</a>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
