<?php
// product.php - Product detail page
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/functions.php';
include __DIR__.'/includes/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $pdo->prepare('SELECT * FROM products WHERE id = ?');
$stmt->execute([$id]);
$product = $stmt->fetch();
if (!$product) {
    echo '<div class="container"><p>Ürün bulunamadı.</p></div>';
    include __DIR__.'/includes/footer.php';
    exit;
}
?>
<div class="container">
    <div class="product-detail" style="display:flex;flex-wrap:wrap;gap:2rem;align-items:flex-start;">
        <div style="flex:1;min-width:260px;">
            <img src="assets/images/<?php echo sanitize($product['image']); ?>" alt="<?php echo sanitize($product['name']); ?>" style="width:100%;max-width:400px;border-radius:12px;">
        </div>
        <div style="flex:2;min-width:260px;">
            <h1><?php echo sanitize($product['name']); ?></h1>
            <div class="price" style="font-size:1.5rem;">₺<?php echo number_format($product['price'],2); ?></div>
            <form method="post" action="cart.php">
                <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
                <button type="submit" class="btn add-to-cart">Sepete Ekle</button>
            </form>
        </div>
    </div>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
